const logincon = require('../app/Controllers/logincon');
const loginmid = require('../app/Middleware/adminlogin');
const gamescontroller = require('../app/Controllers/games')

const multer = require('../app/Helpers/multer')

function webroutes(app) {
    // auth
    app.get('/login', logincon().index)
    app.post('/login', logincon().loginpost)
    app.get('/admin/logout', loginmid, logincon().userlogout)

    app.get('/admin/games', loginmid, gamescontroller().index)
    app.post('/admin/game', loginmid, multer.fields([ { name: 'bannerImage' }, { name: 'logo' }]), gamescontroller().newGameAdd)
    app.post('/admin/game/edit', loginmid, multer.fields([ { name: 'bannerImage' }, { name: 'logo' }]), gamescontroller().gameEdit)
    app.get('/admin/game/delete/:id', loginmid, gamescontroller().gameDelete)

    app.get('/game-like/:id', gamescontroller().gameLike)
    app.get('/popular-game', gamescontroller().popularGameData)
}

module.exports = webroutes